package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(
    days: Option[Integer] = None,
    storageClass: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails = {
    import AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
      .builder()
      .optionallyWith(days.map(value => value: java.lang.Integer))(_.days)
      .optionallyWith(
        storageClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.storageClass)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails =
      zio.aws.securityhub.model
        .AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(
          days.map(value => value),
          storageClass.map(value => value)
        )
    def days: Option[Integer]
    def storageClass: Option[NonEmptyString]
    def getDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("days", days)
    def getStorageClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly {
    override val days: Option[Integer] =
      scala.Option(impl.days()).map(value => value: Integer)
    override val storageClass: Option[NonEmptyString] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.ReadOnly =
    new Wrapper(impl)
}
