package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterPendingModifiedValues(
    automatedSnapshotRetentionPeriod: Option[Integer] = None,
    clusterIdentifier: Option[NonEmptyString] = None,
    clusterType: Option[NonEmptyString] = None,
    clusterVersion: Option[NonEmptyString] = None,
    encryptionType: Option[NonEmptyString] = None,
    enhancedVpcRouting: Option[Boolean] = None,
    maintenanceTrackName: Option[NonEmptyString] = None,
    masterUserPassword: Option[NonEmptyString] = None,
    nodeType: Option[NonEmptyString] = None,
    numberOfNodes: Option[Integer] = None,
    publiclyAccessible: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues = {
    import AwsRedshiftClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
      .builder()
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        clusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterIdentifier)
      .optionallyWith(
        clusterType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterType)
      .optionallyWith(
        clusterVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterVersion)
      .optionallyWith(
        encryptionType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionType)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.maintenanceTrackName)
      .optionallyWith(
        masterUserPassword.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        nodeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeType)
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues =
      zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues(
        automatedSnapshotRetentionPeriod.map(value => value),
        clusterIdentifier.map(value => value),
        clusterType.map(value => value),
        clusterVersion.map(value => value),
        encryptionType.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        masterUserPassword.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value)
      )
    def automatedSnapshotRetentionPeriod: Option[Integer]
    def clusterIdentifier: Option[NonEmptyString]
    def clusterType: Option[NonEmptyString]
    def clusterVersion: Option[NonEmptyString]
    def encryptionType: Option[NonEmptyString]
    def enhancedVpcRouting: Option[Boolean]
    def maintenanceTrackName: Option[NonEmptyString]
    def masterUserPassword: Option[NonEmptyString]
    def nodeType: Option[NonEmptyString]
    def numberOfNodes: Option[Integer]
    def publiclyAccessible: Option[Boolean]
    def getAutomatedSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "automatedSnapshotRetentionPeriod",
        automatedSnapshotRetentionPeriod
      )
    def getClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getClusterVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getEncryptionType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getMasterUserPassword: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getNodeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly {
    override val automatedSnapshotRetentionPeriod: Option[Integer] = scala
      .Option(impl.automatedSnapshotRetentionPeriod())
      .map(value => value: Integer)
    override val clusterIdentifier: Option[NonEmptyString] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterType: Option[NonEmptyString] = scala
      .Option(impl.clusterType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterVersion: Option[NonEmptyString] = scala
      .Option(impl.clusterVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encryptionType: Option[NonEmptyString] = scala
      .Option(impl.encryptionType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enhancedVpcRouting: Option[Boolean] =
      scala.Option(impl.enhancedVpcRouting()).map(value => value: Boolean)
    override val maintenanceTrackName: Option[NonEmptyString] = scala
      .Option(impl.maintenanceTrackName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterUserPassword: Option[NonEmptyString] = scala
      .Option(impl.masterUserPassword())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val nodeType: Option[NonEmptyString] = scala
      .Option(impl.nodeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val numberOfNodes: Option[Integer] =
      scala.Option(impl.numberOfNodes()).map(value => value: Integer)
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues
  ): zio.aws.securityhub.model.AwsRedshiftClusterPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
