package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbOptionGroupMembership(
    optionGroupName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership = {
    import AwsRdsDbOptionGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership
      .builder()
      .optionallyWith(
        optionGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.optionGroupName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership
      .wrap(buildAwsValue())
}
object AwsRdsDbOptionGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership =
      zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership(
        optionGroupName.map(value => value),
        status.map(value => value)
      )
    def optionGroupName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getOptionGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership
  ) extends zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly {
    override val optionGroupName: Option[NonEmptyString] = scala
      .Option(impl.optionGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership
  ): zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly =
    new Wrapper(impl)
}
