package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamInstanceProfile(
    arn: Option[NonEmptyString] = None,
    createDate: Option[NonEmptyString] = None,
    instanceProfileId: Option[NonEmptyString] = None,
    instanceProfileName: Option[NonEmptyString] = None,
    path: Option[NonEmptyString] = None,
    roles: Option[
      Iterable[zio.aws.securityhub.model.AwsIamInstanceProfileRole]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile = {
    import AwsIamInstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        instanceProfileId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProfileId)
      .optionallyWith(
        instanceProfileName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceProfileName)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly =
    zio.aws.securityhub.model.AwsIamInstanceProfile.wrap(buildAwsValue())
}
object AwsIamInstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamInstanceProfile =
      zio.aws.securityhub.model.AwsIamInstanceProfile(
        arn.map(value => value),
        createDate.map(value => value),
        instanceProfileId.map(value => value),
        instanceProfileName.map(value => value),
        path.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[NonEmptyString]
    def createDate: Option[NonEmptyString]
    def instanceProfileId: Option[NonEmptyString]
    def instanceProfileName: Option[NonEmptyString]
    def path: Option[NonEmptyString]
    def roles: Option[
      List[zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getInstanceProfileId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProfileId", instanceProfileId)
    def getInstanceProfileName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly
    ]] = AwsError.unwrapOptionField("roles", roles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ) extends zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createDate: Option[NonEmptyString] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceProfileId: Option[NonEmptyString] = scala
      .Option(impl.instanceProfileId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceProfileName: Option[NonEmptyString] = scala
      .Option(impl.instanceProfileName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roles: Option[
      List[zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly]
    ] = scala
      .Option(impl.roles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamInstanceProfileRole.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile
  ): zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly = new Wrapper(
    impl
  )
}
