package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerListenerDescription(
    listener: Option[zio.aws.securityhub.model.AwsElbLoadBalancerListener] =
      None,
    policyNames: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription = {
    import AwsElbLoadBalancerListenerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerListenerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription =
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription(
        listener.map(value => value.asEditable),
        policyNames.map(value => value)
      )
    def listener
        : Option[zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly]
    def policyNames: Option[List[NonEmptyString]]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
    def getPolicyNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly {
    override val listener: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerListener.ReadOnly
    ] = scala
      .Option(impl.listener())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerListener.wrap(value)
      )
    override val policyNames: Option[List[NonEmptyString]] = scala
      .Option(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerListenerDescription
  ): zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly =
    new Wrapper(impl)
}
