package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerAccessLog(
    emitInterval: Option[Integer] = None,
    enabled: Option[Boolean] = None,
    s3BucketName: Option[NonEmptyString] = None,
    s3BucketPrefix: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog = {
    import AwsElbLoadBalancerAccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog
      .builder()
      .optionallyWith(emitInterval.map(value => value: java.lang.Integer))(
        _.emitInterval
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        s3BucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3BucketPrefix.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketPrefix)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.wrap(buildAwsValue())
}
object AwsElbLoadBalancerAccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog =
      zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog(
        emitInterval.map(value => value),
        enabled.map(value => value),
        s3BucketName.map(value => value),
        s3BucketPrefix.map(value => value)
      )
    def emitInterval: Option[Integer]
    def enabled: Option[Boolean]
    def s3BucketName: Option[NonEmptyString]
    def s3BucketPrefix: Option[NonEmptyString]
    def getEmitInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("emitInterval", emitInterval)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getS3BucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3BucketPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketPrefix", s3BucketPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly {
    override val emitInterval: Option[Integer] =
      scala.Option(impl.emitInterval()).map(value => value: Integer)
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val s3BucketName: Option[NonEmptyString] = scala
      .Option(impl.s3BucketName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3BucketPrefix: Option[NonEmptyString] = scala
      .Option(impl.s3BucketPrefix())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog
  ): zio.aws.securityhub.model.AwsElbLoadBalancerAccessLog.ReadOnly =
    new Wrapper(impl)
}
