package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainLogPublishingOptions(
    indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = None,
    searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = None,
    auditLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions = {
    import AwsElasticsearchDomainLogPublishingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
      .builder()
      .optionallyWith(indexSlowLogs.map(value => value.buildAwsValue()))(
        _.indexSlowLogs
      )
      .optionallyWith(searchSlowLogs.map(value => value.buildAwsValue()))(
        _.searchSlowLogs
      )
      .optionallyWith(auditLogs.map(value => value.buildAwsValue()))(
        _.auditLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainLogPublishingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions =
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions(
        indexSlowLogs.map(value => value.asEditable),
        searchSlowLogs.map(value => value.asEditable),
        auditLogs.map(value => value.asEditable)
      )
    def indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def auditLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ]
    def getIndexSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("indexSlowLogs", indexSlowLogs)
    def getSearchSlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("searchSlowLogs", searchSlowLogs)
    def getAuditLogs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("auditLogs", auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly {
    override val indexSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = scala
      .Option(impl.indexSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
    override val searchSlowLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = scala
      .Option(impl.searchSlowLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
    override val auditLogs: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly
    ] = scala
      .Option(impl.auditLogs())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly =
    new Wrapper(impl)
}
