package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticBeanstalkEnvironmentDetails(
    applicationName: Option[NonEmptyString] = None,
    cname: Option[NonEmptyString] = None,
    dateCreated: Option[NonEmptyString] = None,
    dateUpdated: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    endpointUrl: Option[NonEmptyString] = None,
    environmentArn: Option[NonEmptyString] = None,
    environmentId: Option[NonEmptyString] = None,
    environmentLinks: Option[Iterable[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
    ]] = None,
    environmentName: Option[NonEmptyString] = None,
    optionSettings: Option[Iterable[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
    ]] = None,
    platformArn: Option[NonEmptyString] = None,
    solutionStackName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    tier: Option[zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier] =
      None,
    versionLabel: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails = {
    import AwsElasticBeanstalkEnvironmentDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        cname.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cname)
      .optionallyWith(
        dateCreated.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        endpointUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpointUrl)
      .optionallyWith(
        environmentArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        environmentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentLinks)
      .optionallyWith(
        environmentName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        platformArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        solutionStackName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        versionLabel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.versionLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
      .wrap(buildAwsValue())
}
object AwsElasticBeanstalkEnvironmentDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails =
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails(
        applicationName.map(value => value),
        cname.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        description.map(value => value),
        endpointUrl.map(value => value),
        environmentArn.map(value => value),
        environmentId.map(value => value),
        environmentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentName.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformArn.map(value => value),
        solutionStackName.map(value => value),
        status.map(value => value),
        tier.map(value => value.asEditable),
        versionLabel.map(value => value)
      )
    def applicationName: Option[NonEmptyString]
    def cname: Option[NonEmptyString]
    def dateCreated: Option[NonEmptyString]
    def dateUpdated: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def endpointUrl: Option[NonEmptyString]
    def environmentArn: Option[NonEmptyString]
    def environmentId: Option[NonEmptyString]
    def environmentLinks: Option[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]]
    def environmentName: Option[NonEmptyString]
    def optionSettings: Option[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]]
    def platformArn: Option[NonEmptyString]
    def solutionStackName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def tier: Option[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ]
    def versionLabel: Option[NonEmptyString]
    def getApplicationName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getCname: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cname", cname)
    def getDateCreated: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpointUrl", endpointUrl)
    def getEnvironmentArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getEnvironmentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentLinks: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentLinks", environmentLinks)
    def getEnvironmentName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getPlatformArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getSolutionStackName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getVersionLabel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ) extends zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly {
    override val applicationName: Option[NonEmptyString] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cname: Option[NonEmptyString] = scala
      .Option(impl.cname())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[NonEmptyString] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dateUpdated: Option[NonEmptyString] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpointUrl: Option[NonEmptyString] = scala
      .Option(impl.endpointUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentArn: Option[NonEmptyString] = scala
      .Option(impl.environmentArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentId: Option[NonEmptyString] = scala
      .Option(impl.environmentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentLinks: Option[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.ReadOnly
    ]] = scala
      .Option(impl.environmentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink
            .wrap(item)
        }.toList
      )
    override val environmentName: Option[NonEmptyString] = scala
      .Option(impl.environmentName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val optionSettings: Option[List[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.ReadOnly
    ]] = scala
      .Option(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting
            .wrap(item)
        }.toList
      )
    override val platformArn: Option[NonEmptyString] = scala
      .Option(impl.platformArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val solutionStackName: Option[NonEmptyString] = scala
      .Option(impl.solutionStackName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tier: Option[
      zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.ReadOnly
    ] = scala
      .Option(impl.tier())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentTier.wrap(value)
      )
    override val versionLabel: Option[NonEmptyString] = scala
      .Option(impl.versionLabel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails
  ): zio.aws.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.ReadOnly =
    new Wrapper(impl)
}
