package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(
    containerPort: Option[Integer] = None,
    hostPort: Option[Integer] = None,
    protocol: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
      .builder()
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(hostPort.map(value => value: java.lang.Integer))(
        _.hostPort
      )
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(
          containerPort.map(value => value),
          hostPort.map(value => value),
          protocol.map(value => value)
        )
    def containerPort: Option[Integer]
    def hostPort: Option[Integer]
    def protocol: Option[NonEmptyString]
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly {
    override val containerPort: Option[Integer] =
      scala.Option(impl.containerPort()).map(value => value: Integer)
    override val hostPort: Option[Integer] =
      scala.Option(impl.hostPort()).map(value => value: Integer)
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly =
    new Wrapper(impl)
}
