package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(
    containerPath: Option[NonEmptyString] = None,
    mountOptions: Option[Iterable[NonEmptyString]] = None,
    size: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
      .builder()
      .optionallyWith(
        containerPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerPath)
      .optionallyWith(
        mountOptions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.mountOptions)
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(
          containerPath.map(value => value),
          mountOptions.map(value => value),
          size.map(value => value)
        )
    def containerPath: Option[NonEmptyString]
    def mountOptions: Option[List[NonEmptyString]]
    def size: Option[Integer]
    def getContainerPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getMountOptions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly {
    override val containerPath: Option[NonEmptyString] = scala
      .Option(impl.containerPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val mountOptions: Option[List[NonEmptyString]] = scala
      .Option(impl.mountOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val size: Option[Integer] =
      scala.Option(impl.size()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.ReadOnly =
    new Wrapper(impl)
}
