package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceServiceRegistriesDetails(
    containerName: Option[NonEmptyString] = None,
    containerPort: Option[Integer] = None,
    port: Option[Integer] = None,
    registryArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails = {
    import AwsEcsServiceServiceRegistriesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
      .builder()
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        registryArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.registryArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceServiceRegistriesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails =
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails(
        containerName.map(value => value),
        containerPort.map(value => value),
        port.map(value => value),
        registryArn.map(value => value)
      )
    def containerName: Option[NonEmptyString]
    def containerPort: Option[Integer]
    def port: Option[Integer]
    def registryArn: Option[NonEmptyString]
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getRegistryArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryArn", registryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly {
    override val containerName: Option[NonEmptyString] = scala
      .Option(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerPort: Option[Integer] =
      scala.Option(impl.containerPort()).map(value => value: Integer)
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val registryArn: Option[NonEmptyString] = scala
      .Option(impl.registryArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails
  ): zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly =
    new Wrapper(impl)
}
