package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceDeploymentConfigurationDetails(
    deploymentCircuitBreaker: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
    ] = None,
    maximumPercent: Option[Integer] = None,
    minimumHealthyPercent: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails = {
    import AwsEcsServiceDeploymentConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
      .builder()
      .optionallyWith(
        deploymentCircuitBreaker.map(value => value.buildAwsValue())
      )(_.deploymentCircuitBreaker)
      .optionallyWith(maximumPercent.map(value => value: java.lang.Integer))(
        _.maximumPercent
      )
      .optionallyWith(
        minimumHealthyPercent.map(value => value: java.lang.Integer)
      )(_.minimumHealthyPercent)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceDeploymentConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails =
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails(
        deploymentCircuitBreaker.map(value => value.asEditable),
        maximumPercent.map(value => value),
        minimumHealthyPercent.map(value => value)
      )
    def deploymentCircuitBreaker: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly
    ]
    def maximumPercent: Option[Integer]
    def minimumHealthyPercent: Option[Integer]
    def getDeploymentCircuitBreaker: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentCircuitBreaker",
      deploymentCircuitBreaker
    )
    def getMaximumPercent: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maximumPercent", maximumPercent)
    def getMinimumHealthyPercent: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minimumHealthyPercent", minimumHealthyPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly {
    override val deploymentCircuitBreaker: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly
    ] = scala
      .Option(impl.deploymentCircuitBreaker())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
          .wrap(value)
      )
    override val maximumPercent: Option[Integer] =
      scala.Option(impl.maximumPercent()).map(value => value: Integer)
    override val minimumHealthyPercent: Option[Integer] =
      scala.Option(impl.minimumHealthyPercent()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
