package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VpcEndpointServiceDetails(
    acceptanceRequired: Option[Boolean] = None,
    availabilityZones: Option[Iterable[NonEmptyString]] = None,
    baseEndpointDnsNames: Option[Iterable[NonEmptyString]] = None,
    managesVpcEndpoints: Option[Boolean] = None,
    gatewayLoadBalancerArns: Option[Iterable[NonEmptyString]] = None,
    networkLoadBalancerArns: Option[Iterable[NonEmptyString]] = None,
    privateDnsName: Option[NonEmptyString] = None,
    serviceId: Option[NonEmptyString] = None,
    serviceName: Option[NonEmptyString] = None,
    serviceState: Option[NonEmptyString] = None,
    serviceType: Option[Iterable[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceDetails = {
    import AwsEc2VpcEndpointServiceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceDetails
      .builder()
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        baseEndpointDnsNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.baseEndpointDnsNames)
      .optionallyWith(
        managesVpcEndpoints.map(value => value: java.lang.Boolean)
      )(_.managesVpcEndpoints)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        privateDnsName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateDnsName)
      .optionallyWith(
        serviceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        serviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serviceState)
      .optionallyWith(
        serviceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpcEndpointServiceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails =
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails(
        acceptanceRequired.map(value => value),
        availabilityZones.map(value => value),
        baseEndpointDnsNames.map(value => value),
        managesVpcEndpoints.map(value => value),
        gatewayLoadBalancerArns.map(value => value),
        networkLoadBalancerArns.map(value => value),
        privateDnsName.map(value => value),
        serviceId.map(value => value),
        serviceName.map(value => value),
        serviceState.map(value => value),
        serviceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceptanceRequired: Option[Boolean]
    def availabilityZones: Option[List[NonEmptyString]]
    def baseEndpointDnsNames: Option[List[NonEmptyString]]
    def managesVpcEndpoints: Option[Boolean]
    def gatewayLoadBalancerArns: Option[List[NonEmptyString]]
    def networkLoadBalancerArns: Option[List[NonEmptyString]]
    def privateDnsName: Option[NonEmptyString]
    def serviceId: Option[NonEmptyString]
    def serviceName: Option[NonEmptyString]
    def serviceState: Option[NonEmptyString]
    def serviceType: Option[List[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly
    ]]
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBaseEndpointDnsNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("baseEndpointDnsNames", baseEndpointDnsNames)
    def getManagesVpcEndpoints: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managesVpcEndpoints", managesVpcEndpoints)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "gatewayLoadBalancerArns",
        gatewayLoadBalancerArns
      )
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "networkLoadBalancerArns",
        networkLoadBalancerArns
      )
    def getPrivateDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getServiceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceState", serviceState)
    def getServiceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly {
    override val acceptanceRequired: Option[Boolean] =
      scala.Option(impl.acceptanceRequired()).map(value => value: Boolean)
    override val availabilityZones: Option[List[NonEmptyString]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val baseEndpointDnsNames: Option[List[NonEmptyString]] = scala
      .Option(impl.baseEndpointDnsNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val managesVpcEndpoints: Option[Boolean] =
      scala.Option(impl.managesVpcEndpoints()).map(value => value: Boolean)
    override val gatewayLoadBalancerArns: Option[List[NonEmptyString]] = scala
      .Option(impl.gatewayLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val networkLoadBalancerArns: Option[List[NonEmptyString]] = scala
      .Option(impl.networkLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val privateDnsName: Option[NonEmptyString] = scala
      .Option(impl.privateDnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceId: Option[NonEmptyString] = scala
      .Option(impl.serviceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceName: Option[NonEmptyString] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceState: Option[NonEmptyString] = scala
      .Option(impl.serviceState())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceType: Option[List[
      zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails.ReadOnly
    ]] = scala
      .Option(impl.serviceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceDetails
  ): zio.aws.securityhub.model.AwsEc2VpcEndpointServiceDetails.ReadOnly =
    new Wrapper(impl)
}
