package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupUserIdGroupPair(
    groupId: Option[NonEmptyString] = None,
    groupName: Option[NonEmptyString] = None,
    peeringStatus: Option[NonEmptyString] = None,
    userId: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    vpcPeeringConnectionId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair = {
    import AwsEc2SecurityGroupUserIdGroupPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
      .builder()
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        peeringStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.peeringStatus)
      .optionallyWith(
        userId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
      .wrap(buildAwsValue())
}
object AwsEc2SecurityGroupUserIdGroupPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair =
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair(
        groupId.map(value => value),
        groupName.map(value => value),
        peeringStatus.map(value => value),
        userId.map(value => value),
        vpcId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def groupId: Option[NonEmptyString]
    def groupName: Option[NonEmptyString]
    def peeringStatus: Option[NonEmptyString]
    def userId: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def vpcPeeringConnectionId: Option[NonEmptyString]
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPeeringStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("peeringStatus", peeringStatus)
    def getUserId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userId", userId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly {
    override val groupId: Option[NonEmptyString] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupName: Option[NonEmptyString] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val peeringStatus: Option[NonEmptyString] = scala
      .Option(impl.peeringStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userId: Option[NonEmptyString] = scala
      .Option(impl.userId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcPeeringConnectionId: Option[NonEmptyString] = scala
      .Option(impl.vpcPeeringConnectionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly =
    new Wrapper(impl)
}
