package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkAclAssociation(
    networkAclAssociationId: Option[NonEmptyString] = None,
    networkAclId: Option[NonEmptyString] = None,
    subnetId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation = {
    import AwsEc2NetworkAclAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation
      .builder()
      .optionallyWith(
        networkAclAssociationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkAclAssociationId)
      .optionallyWith(
        networkAclId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkAclId)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.wrap(buildAwsValue())
}
object AwsEc2NetworkAclAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkAclAssociation =
      zio.aws.securityhub.model.AwsEc2NetworkAclAssociation(
        networkAclAssociationId.map(value => value),
        networkAclId.map(value => value),
        subnetId.map(value => value)
      )
    def networkAclAssociationId: Option[NonEmptyString]
    def networkAclId: Option[NonEmptyString]
    def subnetId: Option[NonEmptyString]
    def getNetworkAclAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "networkAclAssociationId",
        networkAclAssociationId
      )
    def getNetworkAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation
  ) extends zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly {
    override val networkAclAssociationId: Option[NonEmptyString] = scala
      .Option(impl.networkAclAssociationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkAclId: Option[NonEmptyString] = scala
      .Option(impl.networkAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetId: Option[NonEmptyString] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation
  ): zio.aws.securityhub.model.AwsEc2NetworkAclAssociation.ReadOnly =
    new Wrapper(impl)
}
