package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2EipDetails(
    instanceId: Option[NonEmptyString] = None,
    publicIp: Option[NonEmptyString] = None,
    allocationId: Option[NonEmptyString] = None,
    associationId: Option[NonEmptyString] = None,
    domain: Option[NonEmptyString] = None,
    publicIpv4Pool: Option[NonEmptyString] = None,
    networkBorderGroup: Option[NonEmptyString] = None,
    networkInterfaceId: Option[NonEmptyString] = None,
    networkInterfaceOwnerId: Option[NonEmptyString] = None,
    privateIpAddress: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails = {
    import AwsEc2EipDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
      .builder()
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        publicIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.publicIp)
      .optionallyWith(
        allocationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.allocationId)
      .optionallyWith(
        associationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        publicIpv4Pool.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicIpv4Pool)
      .optionallyWith(
        networkBorderGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkBorderGroup)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        networkInterfaceOwnerId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceOwnerId)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2EipDetails.wrap(buildAwsValue())
}
object AwsEc2EipDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2EipDetails =
      zio.aws.securityhub.model.AwsEc2EipDetails(
        instanceId.map(value => value),
        publicIp.map(value => value),
        allocationId.map(value => value),
        associationId.map(value => value),
        domain.map(value => value),
        publicIpv4Pool.map(value => value),
        networkBorderGroup.map(value => value),
        networkInterfaceId.map(value => value),
        networkInterfaceOwnerId.map(value => value),
        privateIpAddress.map(value => value)
      )
    def instanceId: Option[NonEmptyString]
    def publicIp: Option[NonEmptyString]
    def allocationId: Option[NonEmptyString]
    def associationId: Option[NonEmptyString]
    def domain: Option[NonEmptyString]
    def publicIpv4Pool: Option[NonEmptyString]
    def networkBorderGroup: Option[NonEmptyString]
    def networkInterfaceId: Option[NonEmptyString]
    def networkInterfaceOwnerId: Option[NonEmptyString]
    def privateIpAddress: Option[NonEmptyString]
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPublicIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAssociationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
    def getPublicIpv4Pool: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIpv4Pool", publicIpv4Pool)
    def getNetworkBorderGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getNetworkInterfaceOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "networkInterfaceOwnerId",
        networkInterfaceOwnerId
      )
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ) extends zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly {
    override val instanceId: Option[NonEmptyString] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIp: Option[NonEmptyString] = scala
      .Option(impl.publicIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocationId: Option[NonEmptyString] = scala
      .Option(impl.allocationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val associationId: Option[NonEmptyString] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domain: Option[NonEmptyString] = scala
      .Option(impl.domain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIpv4Pool: Option[NonEmptyString] = scala
      .Option(impl.publicIpv4Pool())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkBorderGroup: Option[NonEmptyString] = scala
      .Option(impl.networkBorderGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkInterfaceId: Option[NonEmptyString] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkInterfaceOwnerId: Option[NonEmptyString] = scala
      .Option(impl.networkInterfaceOwnerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val privateIpAddress: Option[NonEmptyString] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2EipDetails
  ): zio.aws.securityhub.model.AwsEc2EipDetails.ReadOnly = new Wrapper(impl)
}
