package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableReplica(
    globalSecondaryIndexes: Option[Iterable[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
    ]] = None,
    kmsMasterKeyId: Option[NonEmptyString] = None,
    provisionedThroughputOverride: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
    ] = None,
    regionName: Option[NonEmptyString] = None,
    replicaStatus: Option[NonEmptyString] = None,
    replicaStatusDescription: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica = {
    import AwsDynamoDbTableReplica.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
      .builder()
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        regionName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(
        replicaStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicaStatus)
      .optionallyWith(
        replicaStatusDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.replicaStatusDescription)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableReplica.wrap(buildAwsValue())
}
object AwsDynamoDbTableReplica {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsDynamoDbTableReplica =
      zio.aws.securityhub.model.AwsDynamoDbTableReplica(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        regionName.map(value => value),
        replicaStatus.map(value => value),
        replicaStatusDescription.map(value => value)
      )
    def globalSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]]
    def kmsMasterKeyId: Option[NonEmptyString]
    def provisionedThroughputOverride: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ]
    def regionName: Option[NonEmptyString]
    def replicaStatus: Option[NonEmptyString]
    def replicaStatusDescription: Option[NonEmptyString]
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getKmsMasterKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getRegionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getReplicaStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaStatusDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "replicaStatusDescription",
        replicaStatusDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly {
    override val globalSecondaryIndexes: Option[List[
      zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex.ReadOnly
    ]] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex
            .wrap(item)
        }.toList
      )
    override val kmsMasterKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsMasterKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val provisionedThroughputOverride: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
          .wrap(value)
      )
    override val regionName: Option[NonEmptyString] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replicaStatus: Option[NonEmptyString] = scala
      .Option(impl.replicaStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val replicaStatusDescription: Option[NonEmptyString] = scala
      .Option(impl.replicaStatusDescription())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplica
  ): zio.aws.securityhub.model.AwsDynamoDbTableReplica.ReadOnly = new Wrapper(
    impl
  )
}
