package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableBillingModeSummary(
    billingMode: Option[NonEmptyString] = None,
    lastUpdateToPayPerRequestDateTime: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary = {
    import AwsDynamoDbTableBillingModeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary
      .builder()
      .optionallyWith(
        billingMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.billingMode)
      .optionallyWith(
        lastUpdateToPayPerRequestDateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdateToPayPerRequestDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableBillingModeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary =
      zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary(
        billingMode.map(value => value),
        lastUpdateToPayPerRequestDateTime.map(value => value)
      )
    def billingMode: Option[NonEmptyString]
    def lastUpdateToPayPerRequestDateTime: Option[NonEmptyString]
    def getBillingMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getLastUpdateToPayPerRequestDateTime
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "lastUpdateToPayPerRequestDateTime",
      lastUpdateToPayPerRequestDateTime
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly {
    override val billingMode: Option[NonEmptyString] = scala
      .Option(impl.billingMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastUpdateToPayPerRequestDateTime: Option[NonEmptyString] =
      scala
        .Option(impl.lastUpdateToPayPerRequestDateTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableBillingModeSummary
  ): zio.aws.securityhub.model.AwsDynamoDbTableBillingModeSummary.ReadOnly =
    new Wrapper(impl)
}
