package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginGroup(
    failoverCriteria: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup = {
    import AwsCloudFrontDistributionOriginGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
      .builder()
      .optionallyWith(failoverCriteria.map(value => value.buildAwsValue()))(
        _.failoverCriteria
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup(
        failoverCriteria.map(value => value.asEditable)
      )
    def failoverCriteria: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ]
    def getFailoverCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ] = AwsError.unwrapOptionField("failoverCriteria", failoverCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly {
    override val failoverCriteria: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly
    ] = scala
      .Option(impl.failoverCriteria())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly =
    new Wrapper(impl)
}
