package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(
    onDemandAllocationStrategy: Option[NonEmptyString] = None,
    onDemandBaseCapacity: Option[Integer] = None,
    onDemandPercentageAboveBaseCapacity: Option[Integer] = None,
    spotAllocationStrategy: Option[NonEmptyString] = None,
    spotInstancePools: Option[Integer] = None,
    spotMaxPrice: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
      .builder()
      .optionallyWith(
        onDemandAllocationStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.onDemandAllocationStrategy)
      .optionallyWith(
        onDemandBaseCapacity.map(value => value: java.lang.Integer)
      )(_.onDemandBaseCapacity)
      .optionallyWith(
        onDemandPercentageAboveBaseCapacity.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandPercentageAboveBaseCapacity)
      .optionallyWith(
        spotAllocationStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spotAllocationStrategy)
      .optionallyWith(spotInstancePools.map(value => value: java.lang.Integer))(
        _.spotInstancePools
      )
      .optionallyWith(
        spotMaxPrice.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.spotMaxPrice)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(
          onDemandAllocationStrategy.map(value => value),
          onDemandBaseCapacity.map(value => value),
          onDemandPercentageAboveBaseCapacity.map(value => value),
          spotAllocationStrategy.map(value => value),
          spotInstancePools.map(value => value),
          spotMaxPrice.map(value => value)
        )
    def onDemandAllocationStrategy: Option[NonEmptyString]
    def onDemandBaseCapacity: Option[Integer]
    def onDemandPercentageAboveBaseCapacity: Option[Integer]
    def spotAllocationStrategy: Option[NonEmptyString]
    def spotInstancePools: Option[Integer]
    def spotMaxPrice: Option[NonEmptyString]
    def getOnDemandAllocationStrategy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "onDemandAllocationStrategy",
        onDemandAllocationStrategy
      )
    def getOnDemandBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("onDemandBaseCapacity", onDemandBaseCapacity)
    def getOnDemandPercentageAboveBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "onDemandPercentageAboveBaseCapacity",
        onDemandPercentageAboveBaseCapacity
      )
    def getSpotAllocationStrategy: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("spotAllocationStrategy", spotAllocationStrategy)
    def getSpotInstancePools: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("spotInstancePools", spotInstancePools)
    def getSpotMaxPrice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("spotMaxPrice", spotMaxPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly {
    override val onDemandAllocationStrategy: Option[NonEmptyString] = scala
      .Option(impl.onDemandAllocationStrategy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val onDemandBaseCapacity: Option[Integer] =
      scala.Option(impl.onDemandBaseCapacity()).map(value => value: Integer)
    override val onDemandPercentageAboveBaseCapacity: Option[Integer] = scala
      .Option(impl.onDemandPercentageAboveBaseCapacity())
      .map(value => value: Integer)
    override val spotAllocationStrategy: Option[NonEmptyString] = scala
      .Option(impl.spotAllocationStrategy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val spotInstancePools: Option[Integer] =
      scala.Option(impl.spotInstancePools()).map(value => value: Integer)
    override val spotMaxPrice: Option[NonEmptyString] = scala
      .Option(impl.spotMaxPrice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.ReadOnly =
    new Wrapper(impl)
}
