package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayV2RouteSettings(
    detailedMetricsEnabled: Option[Boolean] = None,
    loggingLevel: Option[NonEmptyString] = None,
    dataTraceEnabled: Option[Boolean] = None,
    throttlingBurstLimit: Option[Integer] = None,
    throttlingRateLimit: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings = {
    import AwsApiGatewayV2RouteSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings
      .builder()
      .optionallyWith(
        detailedMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.detailedMetricsEnabled)
      .optionallyWith(
        loggingLevel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loggingLevel)
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        throttlingBurstLimit.map(value => value: java.lang.Integer)
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.wrap(buildAwsValue())
}
object AwsApiGatewayV2RouteSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings =
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings(
        detailedMetricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        dataTraceEnabled.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value)
      )
    def detailedMetricsEnabled: Option[Boolean]
    def loggingLevel: Option[NonEmptyString]
    def dataTraceEnabled: Option[Boolean]
    def throttlingBurstLimit: Option[Integer]
    def throttlingRateLimit: Option[Double]
    def getDetailedMetricsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("detailedMetricsEnabled", detailedMetricsEnabled)
    def getLoggingLevel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getDataTraceEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly {
    override val detailedMetricsEnabled: Option[Boolean] =
      scala.Option(impl.detailedMetricsEnabled()).map(value => value: Boolean)
    override val loggingLevel: Option[NonEmptyString] = scala
      .Option(impl.loggingLevel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dataTraceEnabled: Option[Boolean] =
      scala.Option(impl.dataTraceEnabled()).map(value => value: Boolean)
    override val throttlingBurstLimit: Option[Integer] =
      scala.Option(impl.throttlingBurstLimit()).map(value => value: Integer)
    override val throttlingRateLimit: Option[Double] =
      scala.Option(impl.throttlingRateLimit()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings
  ): zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly =
    new Wrapper(impl)
}
