package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayV2ApiDetails(
    apiEndpoint: Option[NonEmptyString] = None,
    apiId: Option[NonEmptyString] = None,
    apiKeySelectionExpression: Option[NonEmptyString] = None,
    createdDate: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    version: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    protocolType: Option[NonEmptyString] = None,
    routeSelectionExpression: Option[NonEmptyString] = None,
    corsConfiguration: Option[zio.aws.securityhub.model.AwsCorsConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails = {
    import AwsApiGatewayV2ApiDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
      .builder()
      .optionallyWith(
        apiEndpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.apiEndpoint)
      .optionallyWith(
        apiId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.apiId)
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        protocolType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.protocolType)
      .optionallyWith(
        routeSelectionExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.routeSelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.wrap(buildAwsValue())
}
object AwsApiGatewayV2ApiDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails =
      zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails(
        apiEndpoint.map(value => value),
        apiId.map(value => value),
        apiKeySelectionExpression.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        version.map(value => value),
        name.map(value => value),
        protocolType.map(value => value),
        routeSelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable)
      )
    def apiEndpoint: Option[NonEmptyString]
    def apiId: Option[NonEmptyString]
    def apiKeySelectionExpression: Option[NonEmptyString]
    def createdDate: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def version: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def protocolType: Option[NonEmptyString]
    def routeSelectionExpression: Option[NonEmptyString]
    def corsConfiguration
        : Option[zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly]
    def getApiEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getProtocolType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocolType", protocolType)
    def getRouteSelectionExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "routeSelectionExpression",
        routeSelectionExpression
      )
    def getCorsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly {
    override val apiEndpoint: Option[NonEmptyString] = scala
      .Option(impl.apiEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val apiId: Option[NonEmptyString] = scala
      .Option(impl.apiId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val apiKeySelectionExpression: Option[NonEmptyString] = scala
      .Option(impl.apiKeySelectionExpression())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdDate: Option[NonEmptyString] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocolType: Option[NonEmptyString] = scala
      .Option(impl.protocolType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val routeSelectionExpression: Option[NonEmptyString] = scala
      .Option(impl.routeSelectionExpression())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val corsConfiguration
        : Option[zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly] =
      scala
        .Option(impl.corsConfiguration())
        .map(value =>
          zio.aws.securityhub.model.AwsCorsConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2ApiDetails
  ): zio.aws.securityhub.model.AwsApiGatewayV2ApiDetails.ReadOnly = new Wrapper(
    impl
  )
}
