package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayMethodSettings(
    metricsEnabled: Option[Boolean] = None,
    loggingLevel: Option[NonEmptyString] = None,
    dataTraceEnabled: Option[Boolean] = None,
    throttlingBurstLimit: Option[Integer] = None,
    throttlingRateLimit: Option[Double] = None,
    cachingEnabled: Option[Boolean] = None,
    cacheTtlInSeconds: Option[Integer] = None,
    cacheDataEncrypted: Option[Boolean] = None,
    requireAuthorizationForCacheControl: Option[Boolean] = None,
    unauthorizedCacheControlHeaderStrategy: Option[NonEmptyString] = None,
    httpMethod: Option[NonEmptyString] = None,
    resourcePath: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings = {
    import AwsApiGatewayMethodSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
      .builder()
      .optionallyWith(metricsEnabled.map(value => value: java.lang.Boolean))(
        _.metricsEnabled
      )
      .optionallyWith(
        loggingLevel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loggingLevel)
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        throttlingBurstLimit.map(value => value: java.lang.Integer)
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .optionallyWith(cachingEnabled.map(value => value: java.lang.Boolean))(
        _.cachingEnabled
      )
      .optionallyWith(cacheTtlInSeconds.map(value => value: java.lang.Integer))(
        _.cacheTtlInSeconds
      )
      .optionallyWith(
        cacheDataEncrypted.map(value => value: java.lang.Boolean)
      )(_.cacheDataEncrypted)
      .optionallyWith(
        requireAuthorizationForCacheControl.map(value =>
          value: java.lang.Boolean
        )
      )(_.requireAuthorizationForCacheControl)
      .optionallyWith(
        unauthorizedCacheControlHeaderStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.unauthorizedCacheControlHeaderStrategy)
      .optionallyWith(
        httpMethod.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.httpMethod)
      .optionallyWith(
        resourcePath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourcePath)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayMethodSettings.wrap(buildAwsValue())
}
object AwsApiGatewayMethodSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayMethodSettings =
      zio.aws.securityhub.model.AwsApiGatewayMethodSettings(
        metricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        dataTraceEnabled.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value),
        cachingEnabled.map(value => value),
        cacheTtlInSeconds.map(value => value),
        cacheDataEncrypted.map(value => value),
        requireAuthorizationForCacheControl.map(value => value),
        unauthorizedCacheControlHeaderStrategy.map(value => value),
        httpMethod.map(value => value),
        resourcePath.map(value => value)
      )
    def metricsEnabled: Option[Boolean]
    def loggingLevel: Option[NonEmptyString]
    def dataTraceEnabled: Option[Boolean]
    def throttlingBurstLimit: Option[Integer]
    def throttlingRateLimit: Option[Double]
    def cachingEnabled: Option[Boolean]
    def cacheTtlInSeconds: Option[Integer]
    def cacheDataEncrypted: Option[Boolean]
    def requireAuthorizationForCacheControl: Option[Boolean]
    def unauthorizedCacheControlHeaderStrategy: Option[NonEmptyString]
    def httpMethod: Option[NonEmptyString]
    def resourcePath: Option[NonEmptyString]
    def getMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("metricsEnabled", metricsEnabled)
    def getLoggingLevel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getDataTraceEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
    def getCachingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cachingEnabled", cachingEnabled)
    def getCacheTtlInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheTtlInSeconds", cacheTtlInSeconds)
    def getCacheDataEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheDataEncrypted", cacheDataEncrypted)
    def getRequireAuthorizationForCacheControl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "requireAuthorizationForCacheControl",
        requireAuthorizationForCacheControl
      )
    def getUnauthorizedCacheControlHeaderStrategy
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "unauthorizedCacheControlHeaderStrategy",
      unauthorizedCacheControlHeaderStrategy
    )
    def getHttpMethod: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getResourcePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourcePath", resourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ) extends zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly {
    override val metricsEnabled: Option[Boolean] =
      scala.Option(impl.metricsEnabled()).map(value => value: Boolean)
    override val loggingLevel: Option[NonEmptyString] = scala
      .Option(impl.loggingLevel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dataTraceEnabled: Option[Boolean] =
      scala.Option(impl.dataTraceEnabled()).map(value => value: Boolean)
    override val throttlingBurstLimit: Option[Integer] =
      scala.Option(impl.throttlingBurstLimit()).map(value => value: Integer)
    override val throttlingRateLimit: Option[Double] =
      scala.Option(impl.throttlingRateLimit()).map(value => value: Double)
    override val cachingEnabled: Option[Boolean] =
      scala.Option(impl.cachingEnabled()).map(value => value: Boolean)
    override val cacheTtlInSeconds: Option[Integer] =
      scala.Option(impl.cacheTtlInSeconds()).map(value => value: Integer)
    override val cacheDataEncrypted: Option[Boolean] =
      scala.Option(impl.cacheDataEncrypted()).map(value => value: Boolean)
    override val requireAuthorizationForCacheControl: Option[Boolean] = scala
      .Option(impl.requireAuthorizationForCacheControl())
      .map(value => value: Boolean)
    override val unauthorizedCacheControlHeaderStrategy
        : Option[NonEmptyString] = scala
      .Option(impl.unauthorizedCacheControlHeaderStrategy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpMethod: Option[NonEmptyString] = scala
      .Option(impl.httpMethod())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourcePath: Option[NonEmptyString] = scala
      .Option(impl.resourcePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings
  ): zio.aws.securityhub.model.AwsApiGatewayMethodSettings.ReadOnly =
    new Wrapper(impl)
}
