package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiCallAction(
    api: Option[NonEmptyString] = None,
    serviceName: Option[NonEmptyString] = None,
    callerType: Option[NonEmptyString] = None,
    remoteIpDetails: Option[zio.aws.securityhub.model.ActionRemoteIpDetails] =
      None,
    domainDetails: Option[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails
    ] = None,
    affectedResources: Option[Map[NonEmptyString, NonEmptyString]] = None,
    firstSeen: Option[NonEmptyString] = None,
    lastSeen: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiCallAction = {
    import AwsApiCallAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
      .builder()
      .optionallyWith(
        api.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.api)
      .optionallyWith(
        serviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        callerType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.callerType)
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(domainDetails.map(value => value.buildAwsValue()))(
        _.domainDetails
      )
      .optionallyWith(
        affectedResources.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.affectedResources)
      .optionallyWith(
        firstSeen.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firstSeen)
      .optionallyWith(
        lastSeen.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.lastSeen)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsApiCallAction.ReadOnly =
    zio.aws.securityhub.model.AwsApiCallAction.wrap(buildAwsValue())
}
object AwsApiCallAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiCallAction =
      zio.aws.securityhub.model.AwsApiCallAction(
        api.map(value => value),
        serviceName.map(value => value),
        callerType.map(value => value),
        remoteIpDetails.map(value => value.asEditable),
        domainDetails.map(value => value.asEditable),
        affectedResources.map(value => value),
        firstSeen.map(value => value),
        lastSeen.map(value => value)
      )
    def api: Option[NonEmptyString]
    def serviceName: Option[NonEmptyString]
    def callerType: Option[NonEmptyString]
    def remoteIpDetails
        : Option[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly]
    def domainDetails: Option[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ]
    def affectedResources: Option[Map[NonEmptyString, NonEmptyString]]
    def firstSeen: Option[NonEmptyString]
    def lastSeen: Option[NonEmptyString]
    def getApi: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("api", api)
    def getServiceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getCallerType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("callerType", callerType)
    def getRemoteIpDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getDomainDetails: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ] = AwsError.unwrapOptionField("domainDetails", domainDetails)
    def getAffectedResources
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("affectedResources", affectedResources)
    def getFirstSeen: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ) extends zio.aws.securityhub.model.AwsApiCallAction.ReadOnly {
    override val api: Option[NonEmptyString] = scala
      .Option(impl.api())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceName: Option[NonEmptyString] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val callerType: Option[NonEmptyString] = scala
      .Option(impl.callerType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val remoteIpDetails
        : Option[zio.aws.securityhub.model.ActionRemoteIpDetails.ReadOnly] =
      scala
        .Option(impl.remoteIpDetails())
        .map(value =>
          zio.aws.securityhub.model.ActionRemoteIpDetails.wrap(value)
        )
    override val domainDetails: Option[
      zio.aws.securityhub.model.AwsApiCallActionDomainDetails.ReadOnly
    ] = scala
      .Option(impl.domainDetails())
      .map(value =>
        zio.aws.securityhub.model.AwsApiCallActionDomainDetails.wrap(value)
      )
    override val affectedResources
        : Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.affectedResources())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val firstSeen: Option[NonEmptyString] = scala
      .Option(impl.firstSeen())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastSeen: Option[NonEmptyString] = scala
      .Option(impl.lastSeen())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiCallAction
  ): zio.aws.securityhub.model.AwsApiCallAction.ReadOnly = new Wrapper(impl)
}
