package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptAdministratorInvitationRequest(
    administratorId: NonEmptyString,
    invitationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest = {
    import AcceptAdministratorInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest
      .builder()
      .administratorId(NonEmptyString.unwrap(administratorId): java.lang.String)
      .invitationId(NonEmptyString.unwrap(invitationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AcceptAdministratorInvitationRequest.ReadOnly =
    zio.aws.securityhub.model.AcceptAdministratorInvitationRequest
      .wrap(buildAwsValue())
}
object AcceptAdministratorInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AcceptAdministratorInvitationRequest =
      zio.aws.securityhub.model
        .AcceptAdministratorInvitationRequest(administratorId, invitationId)
    def administratorId: NonEmptyString
    def invitationId: NonEmptyString
    def getAdministratorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(administratorId)
    def getInvitationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(invitationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest
  ) extends zio.aws.securityhub.model.AcceptAdministratorInvitationRequest.ReadOnly {
    override val administratorId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.administratorId())
    override val invitationId: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.invitationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest
  ): zio.aws.securityhub.model.AcceptAdministratorInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
