package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VulnerabilityVendor(
    name: NonEmptyString,
    url: Option[NonEmptyString] = None,
    vendorSeverity: Option[NonEmptyString] = None,
    vendorCreatedAt: Option[NonEmptyString] = None,
    vendorUpdatedAt: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor = {
    import VulnerabilityVendor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        vendorSeverity.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vendorCreatedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vendorCreatedAt)
      .optionallyWith(
        vendorUpdatedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vendorUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly =
    zio.aws.securityhub.model.VulnerabilityVendor.wrap(buildAwsValue())
}
object VulnerabilityVendor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.VulnerabilityVendor =
      zio.aws.securityhub.model.VulnerabilityVendor(
        name,
        url.map(value => value),
        vendorSeverity.map(value => value),
        vendorCreatedAt.map(value => value),
        vendorUpdatedAt.map(value => value)
      )
    def name: NonEmptyString
    def url: Option[NonEmptyString]
    def vendorSeverity: Option[NonEmptyString]
    def vendorCreatedAt: Option[NonEmptyString]
    def vendorUpdatedAt: Option[NonEmptyString]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getVendorSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVendorCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vendorCreatedAt", vendorCreatedAt)
    def getVendorUpdatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vendorUpdatedAt", vendorUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor
  ) extends zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.name())
    override val url: Option[NonEmptyString] = scala
      .Option(impl.url())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vendorSeverity: Option[NonEmptyString] = scala
      .Option(impl.vendorSeverity())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vendorCreatedAt: Option[NonEmptyString] = scala
      .Option(impl.vendorCreatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vendorUpdatedAt: Option[NonEmptyString] = scala
      .Option(impl.vendorUpdatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor
  ): zio.aws.securityhub.model.VulnerabilityVendor.ReadOnly = new Wrapper(impl)
}
