package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFindingsRequest(
    filters: zio.aws.securityhub.model.AwsSecurityFindingFilters,
    note: Option[zio.aws.securityhub.model.NoteUpdate] = None,
    recordState: Option[zio.aws.securityhub.model.RecordState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest = {
    import UpdateFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest
      .builder()
      .filters(filters.buildAwsValue())
      .optionallyWith(note.map(value => value.buildAwsValue()))(_.note)
      .optionallyWith(recordState.map(value => value.unwrap))(_.recordState)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.UpdateFindingsRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateFindingsRequest.wrap(buildAwsValue())
}
object UpdateFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateFindingsRequest =
      zio.aws.securityhub.model.UpdateFindingsRequest(
        filters.asEditable,
        note.map(value => value.asEditable),
        recordState.map(value => value)
      )
    def filters: zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    def note: Option[zio.aws.securityhub.model.NoteUpdate.ReadOnly]
    def recordState: Option[zio.aws.securityhub.model.RecordState]
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getNote
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      AwsError.unwrapOptionField("note", note)
    def getRecordState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.RecordState] =
      AwsError.unwrapOptionField("recordState", recordState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest
  ) extends zio.aws.securityhub.model.UpdateFindingsRequest.ReadOnly {
    override val filters
        : zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly =
      zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(impl.filters())
    override val note: Option[zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      scala
        .Option(impl.note())
        .map(value => zio.aws.securityhub.model.NoteUpdate.wrap(value))
    override val recordState: Option[zio.aws.securityhub.model.RecordState] =
      scala
        .Option(impl.recordState())
        .map(value => zio.aws.securityhub.model.RecordState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest
  ): zio.aws.securityhub.model.UpdateFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
