package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFindingAggregatorRequest(
    findingAggregatorArn: NonEmptyString,
    regionLinkingMode: NonEmptyString,
    regions: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest = {
    import UpdateFindingAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest
      .builder()
      .findingAggregatorArn(
        NonEmptyString.unwrap(findingAggregatorArn): java.lang.String
      )
      .regionLinkingMode(
        NonEmptyString.unwrap(regionLinkingMode): java.lang.String
      )
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UpdateFindingAggregatorRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateFindingAggregatorRequest
      .wrap(buildAwsValue())
}
object UpdateFindingAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateFindingAggregatorRequest =
      zio.aws.securityhub.model.UpdateFindingAggregatorRequest(
        findingAggregatorArn,
        regionLinkingMode,
        regions.map(value => value)
      )
    def findingAggregatorArn: NonEmptyString
    def regionLinkingMode: NonEmptyString
    def regions: Option[List[NonEmptyString]]
    def getFindingAggregatorArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(findingAggregatorArn)
    def getRegionLinkingMode: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(regionLinkingMode)
    def getRegions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest
  ) extends zio.aws.securityhub.model.UpdateFindingAggregatorRequest.ReadOnly {
    override val findingAggregatorArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.findingAggregatorArn())
    override val regionLinkingMode: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.regionLinkingMode())
    override val regions: Option[List[NonEmptyString]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest
  ): zio.aws.securityhub.model.UpdateFindingAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
