package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateActionTargetRequest(
    actionTargetArn: NonEmptyString,
    name: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest = {
    import UpdateActionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest
      .builder()
      .actionTargetArn(NonEmptyString.unwrap(actionTargetArn): java.lang.String)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.UpdateActionTargetRequest.ReadOnly =
    zio.aws.securityhub.model.UpdateActionTargetRequest.wrap(buildAwsValue())
}
object UpdateActionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UpdateActionTargetRequest =
      zio.aws.securityhub.model.UpdateActionTargetRequest(
        actionTargetArn,
        name.map(value => value),
        description.map(value => value)
      )
    def actionTargetArn: NonEmptyString
    def name: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def getActionTargetArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(actionTargetArn)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest
  ) extends zio.aws.securityhub.model.UpdateActionTargetRequest.ReadOnly {
    override val actionTargetArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.actionTargetArn())
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest
  ): zio.aws.securityhub.model.UpdateActionTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
