package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StatelessCustomPublishMetricAction(
    dimensions: Option[Iterable[
      zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricAction = {
    import StatelessCustomPublishMetricAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricAction
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly =
    zio.aws.securityhub.model.StatelessCustomPublishMetricAction
      .wrap(buildAwsValue())
}
object StatelessCustomPublishMetricAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.StatelessCustomPublishMetricAction =
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions: Option[List[
      zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly
    ]]
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricAction
  ) extends zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly {
    override val dimensions: Option[List[
      zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension.ReadOnly
    ]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StatelessCustomPublishMetricActionDimension
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomPublishMetricAction
  ): zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly =
    new Wrapper(impl)
}
