package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StatelessCustomActionDefinition(
    publishMetricAction: Option[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition = {
    import StatelessCustomActionDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
      .builder()
      .optionallyWith(publishMetricAction.map(value => value.buildAwsValue()))(
        _.publishMetricAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly =
    zio.aws.securityhub.model.StatelessCustomActionDefinition
      .wrap(buildAwsValue())
}
object StatelessCustomActionDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StatelessCustomActionDefinition =
      zio.aws.securityhub.model.StatelessCustomActionDefinition(
        publishMetricAction.map(value => value.asEditable)
      )
    def publishMetricAction: Option[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ]
    def getPublishMetricAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ] = AwsError.unwrapOptionField("publishMetricAction", publishMetricAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ) extends zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly {
    override val publishMetricAction: Option[
      zio.aws.securityhub.model.StatelessCustomPublishMetricAction.ReadOnly
    ] = scala
      .Option(impl.publishMetricAction())
      .map(value =>
        zio.aws.securityhub.model.StatelessCustomPublishMetricAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatelessCustomActionDefinition
  ): zio.aws.securityhub.model.StatelessCustomActionDefinition.ReadOnly =
    new Wrapper(impl)
}
