package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SoftwarePackage(
    name: Option[NonEmptyString] = None,
    version: Option[NonEmptyString] = None,
    epoch: Option[NonEmptyString] = None,
    release: Option[NonEmptyString] = None,
    architecture: Option[NonEmptyString] = None,
    packageManager: Option[NonEmptyString] = None,
    filePath: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SoftwarePackage = {
    import SoftwarePackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SoftwarePackage
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        epoch.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.epoch)
      .optionallyWith(
        release.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.release)
      .optionallyWith(
        architecture.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.architecture)
      .optionallyWith(
        packageManager.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.packageManager)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SoftwarePackage.ReadOnly =
    zio.aws.securityhub.model.SoftwarePackage.wrap(buildAwsValue())
}
object SoftwarePackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SoftwarePackage =
      zio.aws.securityhub.model.SoftwarePackage(
        name.map(value => value),
        version.map(value => value),
        epoch.map(value => value),
        release.map(value => value),
        architecture.map(value => value),
        packageManager.map(value => value),
        filePath.map(value => value)
      )
    def name: Option[NonEmptyString]
    def version: Option[NonEmptyString]
    def epoch: Option[NonEmptyString]
    def release: Option[NonEmptyString]
    def architecture: Option[NonEmptyString]
    def packageManager: Option[NonEmptyString]
    def filePath: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getEpoch: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getRelease: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("release", release)
    def getArchitecture: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getPackageManager: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageManager", packageManager)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ) extends zio.aws.securityhub.model.SoftwarePackage.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val epoch: Option[NonEmptyString] = scala
      .Option(impl.epoch())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val release: Option[NonEmptyString] = scala
      .Option(impl.release())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val architecture: Option[NonEmptyString] = scala
      .Option(impl.architecture())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val packageManager: Option[NonEmptyString] = scala
      .Option(impl.packageManager())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val filePath: Option[NonEmptyString] = scala
      .Option(impl.filePath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SoftwarePackage
  ): zio.aws.securityhub.model.SoftwarePackage.ReadOnly = new Wrapper(impl)
}
