package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.RatioScale
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SeverityUpdate(
    normalized: Option[RatioScale] = None,
    product: Option[Double] = None,
    label: Option[zio.aws.securityhub.model.SeverityLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SeverityUpdate = {
    import SeverityUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SeverityUpdate
      .builder()
      .optionallyWith(
        normalized.map(value => RatioScale.unwrap(value): Integer)
      )(_.normalized)
      .optionallyWith(product.map(value => value: java.lang.Double))(_.product)
      .optionallyWith(label.map(value => value.unwrap))(_.label)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SeverityUpdate.ReadOnly =
    zio.aws.securityhub.model.SeverityUpdate.wrap(buildAwsValue())
}
object SeverityUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SeverityUpdate =
      zio.aws.securityhub.model.SeverityUpdate(
        normalized.map(value => value),
        product.map(value => value),
        label.map(value => value)
      )
    def normalized: Option[RatioScale]
    def product: Option[Double]
    def label: Option[zio.aws.securityhub.model.SeverityLabel]
    def getNormalized: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("normalized", normalized)
    def getProduct: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("product", product)
    def getLabel: ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityLabel] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ) extends zio.aws.securityhub.model.SeverityUpdate.ReadOnly {
    override val normalized: Option[RatioScale] = scala
      .Option(impl.normalized())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val product: Option[Double] =
      scala.Option(impl.product()).map(value => value: Double)
    override val label: Option[zio.aws.securityhub.model.SeverityLabel] = scala
      .Option(impl.label())
      .map(value => zio.aws.securityhub.model.SeverityLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SeverityUpdate
  ): zio.aws.securityhub.model.SeverityUpdate.ReadOnly = new Wrapper(impl)
}
