package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatelessRulesDetails(
    priority: Option[Integer] = None,
    ruleDefinition: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails = {
    import RuleGroupSourceStatelessRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
      .builder()
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(ruleDefinition.map(value => value.buildAwsValue()))(
        _.ruleDefinition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatelessRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails(
        priority.map(value => value),
        ruleDefinition.map(value => value.asEditable)
      )
    def priority: Option[Integer]
    def ruleDefinition: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ]
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("ruleDefinition", ruleDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly {
    override val priority: Option[Integer] =
      scala.Option(impl.priority()).map(value => value: Integer)
    override val ruleDefinition: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition.ReadOnly
    ] = scala
      .Option(impl.ruleDefinition())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatelessRuleDefinition
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatelessRulesDetails.ReadOnly =
    new Wrapper(impl)
}
