package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatefulRulesHeaderDetails(
    destination: Option[NonEmptyString] = None,
    destinationPort: Option[NonEmptyString] = None,
    direction: Option[NonEmptyString] = None,
    protocol: Option[NonEmptyString] = None,
    source: Option[NonEmptyString] = None,
    sourcePort: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails = {
    import RuleGroupSourceStatefulRulesHeaderDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
      .builder()
      .optionallyWith(
        destination.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(
        destinationPort.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.destinationPort)
      .optionallyWith(
        direction.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.direction)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        sourcePort.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourcePort)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatefulRulesHeaderDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails(
        destination.map(value => value),
        destinationPort.map(value => value),
        direction.map(value => value),
        protocol.map(value => value),
        source.map(value => value),
        sourcePort.map(value => value)
      )
    def destination: Option[NonEmptyString]
    def destinationPort: Option[NonEmptyString]
    def direction: Option[NonEmptyString]
    def protocol: Option[NonEmptyString]
    def source: Option[NonEmptyString]
    def sourcePort: Option[NonEmptyString]
    def getDestination: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destination", destination)
    def getDestinationPort: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getDirection: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("direction", direction)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
    def getSourcePort: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourcePort", sourcePort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly {
    override val destination: Option[NonEmptyString] = scala
      .Option(impl.destination())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val destinationPort: Option[NonEmptyString] = scala
      .Option(impl.destinationPort())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val direction: Option[NonEmptyString] = scala
      .Option(impl.direction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val source: Option[NonEmptyString] = scala
      .Option(impl.source())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourcePort: Option[NonEmptyString] = scala
      .Option(impl.sourcePort())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly =
    new Wrapper(impl)
}
