package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSourceStatefulRulesDetails(
    action: Option[NonEmptyString] = None,
    header: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
    ] = None,
    ruleOptions: Option[Iterable[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails = {
    import RuleGroupSourceStatefulRulesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails
      .builder()
      .optionallyWith(
        action.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(header.map(value => value.buildAwsValue()))(_.header)
      .optionallyWith(
        ruleOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails
      .wrap(buildAwsValue())
}
object RuleGroupSourceStatefulRulesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails =
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails(
        action.map(value => value),
        header.map(value => value.asEditable),
        ruleOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def action: Option[NonEmptyString]
    def header: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly
    ]
    def ruleOptions: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly
    ]]
    def getAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("action", action)
    def getHeader: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly
    ] = AwsError.unwrapOptionField("header", header)
    def getRuleOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleOptions", ruleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails
  ) extends zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly {
    override val action: Option[NonEmptyString] = scala
      .Option(impl.action())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val header: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails.ReadOnly
    ] = scala
      .Option(impl.header())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails
          .wrap(value)
      )
    override val ruleOptions: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails.ReadOnly
    ]] = scala
      .Option(impl.ruleOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails
  ): zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly =
    new Wrapper(impl)
}
