package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleGroupSource(
    rulesSourceList: Option[
      zio.aws.securityhub.model.RuleGroupSourceListDetails
    ] = None,
    rulesString: Option[NonEmptyString] = None,
    statefulRules: Option[
      Iterable[zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails]
    ] = None,
    statelessRulesAndCustomActions: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.RuleGroupSource = {
    import RuleGroupSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.RuleGroupSource
      .builder()
      .optionallyWith(rulesSourceList.map(value => value.buildAwsValue()))(
        _.rulesSourceList
      )
      .optionallyWith(
        rulesString.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.rulesString)
      .optionallyWith(
        statefulRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRules)
      .optionallyWith(
        statelessRulesAndCustomActions.map(value => value.buildAwsValue())
      )(_.statelessRulesAndCustomActions)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.RuleGroupSource.ReadOnly =
    zio.aws.securityhub.model.RuleGroupSource.wrap(buildAwsValue())
}
object RuleGroupSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.RuleGroupSource =
      zio.aws.securityhub.model.RuleGroupSource(
        rulesSourceList.map(value => value.asEditable),
        rulesString.map(value => value),
        statefulRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessRulesAndCustomActions.map(value => value.asEditable)
      )
    def rulesSourceList
        : Option[zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly]
    def rulesString: Option[NonEmptyString]
    def statefulRules: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]]
    def statelessRulesAndCustomActions: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ]
    def getRulesSourceList: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly
    ] = AwsError.unwrapOptionField("rulesSourceList", rulesSourceList)
    def getRulesString: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rulesString", rulesString)
    def getStatefulRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("statefulRules", statefulRules)
    def getStatelessRulesAndCustomActions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "statelessRulesAndCustomActions",
      statelessRulesAndCustomActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ) extends zio.aws.securityhub.model.RuleGroupSource.ReadOnly {
    override val rulesSourceList: Option[
      zio.aws.securityhub.model.RuleGroupSourceListDetails.ReadOnly
    ] = scala
      .Option(impl.rulesSourceList())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceListDetails.wrap(value)
      )
    override val rulesString: Option[NonEmptyString] = scala
      .Option(impl.rulesString())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statefulRules: Option[List[
      zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails.ReadOnly
    ]] = scala
      .Option(impl.statefulRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.RuleGroupSourceStatefulRulesDetails
            .wrap(item)
        }.toList
      )
    override val statelessRulesAndCustomActions: Option[
      zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails.ReadOnly
    ] = scala
      .Option(impl.statelessRulesAndCustomActions())
      .map(value =>
        zio.aws.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.RuleGroupSource
  ): zio.aws.securityhub.model.RuleGroupSource.ReadOnly = new Wrapper(impl)
}
