package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Record(
    jsonPath: Option[NonEmptyString] = None,
    recordIndex: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Record
      .builder()
      .optionallyWith(
        jsonPath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.jsonPath)
      .optionallyWith(recordIndex.map(value => value: java.lang.Long))(
        _.recordIndex
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Record.ReadOnly =
    zio.aws.securityhub.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Record
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Record = zio.aws.securityhub.model
      .Record(jsonPath.map(value => value), recordIndex.map(value => value))
    def jsonPath: Option[NonEmptyString]
    def recordIndex: Option[Long]
    def getJsonPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("jsonPath", jsonPath)
    def getRecordIndex: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("recordIndex", recordIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Record
  ) extends zio.aws.securityhub.model.Record.ReadOnly {
    override val jsonPath: Option[NonEmptyString] = scala
      .Option(impl.jsonPath())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val recordIndex: Option[Long] =
      scala.Option(impl.recordIndex()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Record
  ): zio.aws.securityhub.model.Record.ReadOnly = new Wrapper(impl)
}
