package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Product(
    productArn: NonEmptyString,
    productName: Option[NonEmptyString] = None,
    companyName: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    categories: Option[Iterable[NonEmptyString]] = None,
    integrationTypes: Option[
      Iterable[zio.aws.securityhub.model.IntegrationType]
    ] = None,
    marketplaceUrl: Option[NonEmptyString] = None,
    activationUrl: Option[NonEmptyString] = None,
    productSubscriptionResourcePolicy: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Product = {
    import Product.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Product
      .builder()
      .productArn(NonEmptyString.unwrap(productArn): java.lang.String)
      .optionallyWith(
        productName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.productName)
      .optionallyWith(
        companyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.companyName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categories)
      .optionallyWith(
        integrationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.integrationTypesWithStrings)
      .optionallyWith(
        marketplaceUrl.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.marketplaceUrl)
      .optionallyWith(
        activationUrl.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.activationUrl)
      .optionallyWith(
        productSubscriptionResourcePolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.productSubscriptionResourcePolicy)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Product.ReadOnly =
    zio.aws.securityhub.model.Product.wrap(buildAwsValue())
}
object Product {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Product
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Product =
      zio.aws.securityhub.model.Product(
        productArn,
        productName.map(value => value),
        companyName.map(value => value),
        description.map(value => value),
        categories.map(value => value),
        integrationTypes.map(value => value),
        marketplaceUrl.map(value => value),
        activationUrl.map(value => value),
        productSubscriptionResourcePolicy.map(value => value)
      )
    def productArn: NonEmptyString
    def productName: Option[NonEmptyString]
    def companyName: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def categories: Option[List[NonEmptyString]]
    def integrationTypes
        : Option[List[zio.aws.securityhub.model.IntegrationType]]
    def marketplaceUrl: Option[NonEmptyString]
    def activationUrl: Option[NonEmptyString]
    def productSubscriptionResourcePolicy: Option[NonEmptyString]
    def getProductArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(productArn)
    def getProductName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("productName", productName)
    def getCompanyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("companyName", companyName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCategories: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("categories", categories)
    def getIntegrationTypes
        : ZIO[Any, AwsError, List[zio.aws.securityhub.model.IntegrationType]] =
      AwsError.unwrapOptionField("integrationTypes", integrationTypes)
    def getMarketplaceUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("marketplaceUrl", marketplaceUrl)
    def getActivationUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("activationUrl", activationUrl)
    def getProductSubscriptionResourcePolicy
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "productSubscriptionResourcePolicy",
      productSubscriptionResourcePolicy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Product
  ) extends zio.aws.securityhub.model.Product.ReadOnly {
    override val productArn: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.productArn())
    override val productName: Option[NonEmptyString] = scala
      .Option(impl.productName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val companyName: Option[NonEmptyString] = scala
      .Option(impl.companyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val categories: Option[List[NonEmptyString]] = scala
      .Option(impl.categories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val integrationTypes
        : Option[List[zio.aws.securityhub.model.IntegrationType]] = scala
      .Option(impl.integrationTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IntegrationType.wrap(item)
        }.toList
      )
    override val marketplaceUrl: Option[NonEmptyString] = scala
      .Option(impl.marketplaceUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val activationUrl: Option[NonEmptyString] = scala
      .Option(impl.activationUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val productSubscriptionResourcePolicy: Option[NonEmptyString] =
      scala
        .Option(impl.productSubscriptionResourcePolicy())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Product
  ): zio.aws.securityhub.model.Product.ReadOnly = new Wrapper(impl)
}
