package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProcessDetails(
    name: Option[NonEmptyString] = None,
    path: Option[NonEmptyString] = None,
    pid: Option[Integer] = None,
    parentPid: Option[Integer] = None,
    launchedAt: Option[NonEmptyString] = None,
    terminatedAt: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ProcessDetails = {
    import ProcessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ProcessDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(pid.map(value => value: java.lang.Integer))(_.pid)
      .optionallyWith(parentPid.map(value => value: java.lang.Integer))(
        _.parentPid
      )
      .optionallyWith(
        launchedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchedAt)
      .optionallyWith(
        terminatedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.terminatedAt)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ProcessDetails.ReadOnly =
    zio.aws.securityhub.model.ProcessDetails.wrap(buildAwsValue())
}
object ProcessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ProcessDetails =
      zio.aws.securityhub.model.ProcessDetails(
        name.map(value => value),
        path.map(value => value),
        pid.map(value => value),
        parentPid.map(value => value),
        launchedAt.map(value => value),
        terminatedAt.map(value => value)
      )
    def name: Option[NonEmptyString]
    def path: Option[NonEmptyString]
    def pid: Option[Integer]
    def parentPid: Option[Integer]
    def launchedAt: Option[NonEmptyString]
    def terminatedAt: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getPid: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pid", pid)
    def getParentPid: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("parentPid", parentPid)
    def getLaunchedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getTerminatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("terminatedAt", terminatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ) extends zio.aws.securityhub.model.ProcessDetails.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pid: Option[Integer] =
      scala.Option(impl.pid()).map(value => value: Integer)
    override val parentPid: Option[Integer] =
      scala.Option(impl.parentPid()).map(value => value: Integer)
    override val launchedAt: Option[NonEmptyString] = scala
      .Option(impl.launchedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val terminatedAt: Option[NonEmptyString] = scala
      .Option(impl.terminatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ProcessDetails
  ): zio.aws.securityhub.model.ProcessDetails.ReadOnly = new Wrapper(impl)
}
