package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PatchSummary(
    id: NonEmptyString,
    installedCount: Option[Integer] = None,
    missingCount: Option[Integer] = None,
    failedCount: Option[Integer] = None,
    installedOtherCount: Option[Integer] = None,
    installedRejectedCount: Option[Integer] = None,
    installedPendingReboot: Option[Integer] = None,
    operationStartTime: Option[NonEmptyString] = None,
    operationEndTime: Option[NonEmptyString] = None,
    rebootOption: Option[NonEmptyString] = None,
    operation: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PatchSummary = {
    import PatchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PatchSummary
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(installedCount.map(value => value: java.lang.Integer))(
        _.installedCount
      )
      .optionallyWith(missingCount.map(value => value: java.lang.Integer))(
        _.missingCount
      )
      .optionallyWith(failedCount.map(value => value: java.lang.Integer))(
        _.failedCount
      )
      .optionallyWith(
        installedOtherCount.map(value => value: java.lang.Integer)
      )(_.installedOtherCount)
      .optionallyWith(
        installedRejectedCount.map(value => value: java.lang.Integer)
      )(_.installedRejectedCount)
      .optionallyWith(
        installedPendingReboot.map(value => value: java.lang.Integer)
      )(_.installedPendingReboot)
      .optionallyWith(
        operationStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.operationStartTime)
      .optionallyWith(
        operationEndTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.operationEndTime)
      .optionallyWith(
        rebootOption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rebootOption)
      .optionallyWith(
        operation.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.operation)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PatchSummary.ReadOnly =
    zio.aws.securityhub.model.PatchSummary.wrap(buildAwsValue())
}
object PatchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PatchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PatchSummary =
      zio.aws.securityhub.model.PatchSummary(
        id,
        installedCount.map(value => value),
        missingCount.map(value => value),
        failedCount.map(value => value),
        installedOtherCount.map(value => value),
        installedRejectedCount.map(value => value),
        installedPendingReboot.map(value => value),
        operationStartTime.map(value => value),
        operationEndTime.map(value => value),
        rebootOption.map(value => value),
        operation.map(value => value)
      )
    def id: NonEmptyString
    def installedCount: Option[Integer]
    def missingCount: Option[Integer]
    def failedCount: Option[Integer]
    def installedOtherCount: Option[Integer]
    def installedRejectedCount: Option[Integer]
    def installedPendingReboot: Option[Integer]
    def operationStartTime: Option[NonEmptyString]
    def operationEndTime: Option[NonEmptyString]
    def rebootOption: Option[NonEmptyString]
    def operation: Option[NonEmptyString]
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getInstalledCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("installedCount", installedCount)
    def getMissingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("missingCount", missingCount)
    def getFailedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedCount", failedCount)
    def getInstalledOtherCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("installedOtherCount", installedOtherCount)
    def getInstalledRejectedCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("installedRejectedCount", installedRejectedCount)
    def getInstalledPendingReboot: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("installedPendingReboot", installedPendingReboot)
    def getOperationStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operationStartTime", operationStartTime)
    def getOperationEndTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operationEndTime", operationEndTime)
    def getRebootOption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rebootOption", rebootOption)
    def getOperation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PatchSummary
  ) extends zio.aws.securityhub.model.PatchSummary.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val installedCount: Option[Integer] =
      scala.Option(impl.installedCount()).map(value => value: Integer)
    override val missingCount: Option[Integer] =
      scala.Option(impl.missingCount()).map(value => value: Integer)
    override val failedCount: Option[Integer] =
      scala.Option(impl.failedCount()).map(value => value: Integer)
    override val installedOtherCount: Option[Integer] =
      scala.Option(impl.installedOtherCount()).map(value => value: Integer)
    override val installedRejectedCount: Option[Integer] =
      scala.Option(impl.installedRejectedCount()).map(value => value: Integer)
    override val installedPendingReboot: Option[Integer] =
      scala.Option(impl.installedPendingReboot()).map(value => value: Integer)
    override val operationStartTime: Option[NonEmptyString] = scala
      .Option(impl.operationStartTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val operationEndTime: Option[NonEmptyString] = scala
      .Option(impl.operationEndTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rebootOption: Option[NonEmptyString] = scala
      .Option(impl.rebootOption())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val operation: Option[NonEmptyString] = scala
      .Option(impl.operation())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PatchSummary
  ): zio.aws.securityhub.model.PatchSummary.ReadOnly = new Wrapper(impl)
}
