package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NextToken, AdminsMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOrganizationAdminAccountsRequest(
    maxResults: Option[AdminsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest = {
    import ListOrganizationAdminAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => AdminsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest =
      zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[AdminsMaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, AdminsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ) extends zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly {
    override val maxResults: Option[AdminsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.securityhub.model.primitives.AdminsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest
  ): zio.aws.securityhub.model.ListOrganizationAdminAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
