package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NextToken, CrossAccountMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInvitationsRequest(
    maxResults: Option[CrossAccountMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest = {
    import ListInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => CrossAccountMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ListInvitationsRequest.ReadOnly =
    zio.aws.securityhub.model.ListInvitationsRequest.wrap(buildAwsValue())
}
object ListInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListInvitationsRequest =
      zio.aws.securityhub.model.ListInvitationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[CrossAccountMaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, CrossAccountMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest
  ) extends zio.aws.securityhub.model.ListInvitationsRequest.ReadOnly {
    override val maxResults: Option[CrossAccountMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.securityhub.model.primitives.CrossAccountMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest
  ): zio.aws.securityhub.model.ListInvitationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
