package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFindingAggregatorsResponse(
    findingAggregators: Option[
      Iterable[zio.aws.securityhub.model.FindingAggregator]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse = {
    import ListFindingAggregatorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse
      .builder()
      .optionallyWith(
        findingAggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingAggregators)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly =
    zio.aws.securityhub.model.ListFindingAggregatorsResponse
      .wrap(buildAwsValue())
}
object ListFindingAggregatorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ListFindingAggregatorsResponse =
      zio.aws.securityhub.model.ListFindingAggregatorsResponse(
        findingAggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findingAggregators
        : Option[List[zio.aws.securityhub.model.FindingAggregator.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFindingAggregators: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FindingAggregator.ReadOnly
    ]] = AwsError.unwrapOptionField("findingAggregators", findingAggregators)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse
  ) extends zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly {
    override val findingAggregators
        : Option[List[zio.aws.securityhub.model.FindingAggregator.ReadOnly]] =
      scala
        .Option(impl.findingAggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.FindingAggregator.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse
  ): zio.aws.securityhub.model.ListFindingAggregatorsResponse.ReadOnly =
    new Wrapper(impl)
}
