package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IcmpTypeCode(
    code: Option[Integer] = None,
    `type`: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.IcmpTypeCode = {
    import IcmpTypeCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.IcmpTypeCode
      .builder()
      .optionallyWith(code.map(value => value: java.lang.Integer))(_.code)
      .optionallyWith(`type`.map(value => value: java.lang.Integer))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.IcmpTypeCode.ReadOnly =
    zio.aws.securityhub.model.IcmpTypeCode.wrap(buildAwsValue())
}
object IcmpTypeCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.IcmpTypeCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.IcmpTypeCode =
      zio.aws.securityhub.model
        .IcmpTypeCode(code.map(value => value), `type`.map(value => value))
    def code: Option[Integer]
    def `type`: Option[Integer]
    def getCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("code", code)
    def getType: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.IcmpTypeCode
  ) extends zio.aws.securityhub.model.IcmpTypeCode.ReadOnly {
    override val code: Option[Integer] =
      scala.Option(impl.code()).map(value => value: Integer)
    override val `type`: Option[Integer] =
      scala.Option(impl.`type`()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.IcmpTypeCode
  ): zio.aws.securityhub.model.IcmpTypeCode.ReadOnly = new Wrapper(impl)
}
