package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFindingsResponse(
    findings: Iterable[zio.aws.securityhub.model.AwsSecurityFinding],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GetFindingsResponse = {
    import GetFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GetFindingsResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GetFindingsResponse.ReadOnly =
    zio.aws.securityhub.model.GetFindingsResponse.wrap(buildAwsValue())
}
object GetFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GetFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GetFindingsResponse =
      zio.aws.securityhub.model.GetFindingsResponse(
        findings.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def findings: List[zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly]
    def nextToken: Option[NextToken]
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly
    ]] = ZIO.succeed(findings)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsResponse
  ) extends zio.aws.securityhub.model.GetFindingsResponse.ReadOnly {
    override val findings
        : List[zio.aws.securityhub.model.AwsSecurityFinding.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AwsSecurityFinding.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GetFindingsResponse
  ): zio.aws.securityhub.model.GetFindingsResponse.ReadOnly = new Wrapper(impl)
}
