package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GeoLocation(
    lon: Option[Double] = None,
    lat: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.GeoLocation = {
    import GeoLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.GeoLocation
      .builder()
      .optionallyWith(lon.map(value => value: java.lang.Double))(_.lon)
      .optionallyWith(lat.map(value => value: java.lang.Double))(_.lat)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.GeoLocation.ReadOnly =
    zio.aws.securityhub.model.GeoLocation.wrap(buildAwsValue())
}
object GeoLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.GeoLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.GeoLocation =
      zio.aws.securityhub.model
        .GeoLocation(lon.map(value => value), lat.map(value => value))
    def lon: Option[Double]
    def lat: Option[Double]
    def getLon: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lon", lon)
    def getLat: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lat", lat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.GeoLocation
  ) extends zio.aws.securityhub.model.GeoLocation.ReadOnly {
    override val lon: Option[Double] =
      scala.Option(impl.lon()).map(value => value: Double)
    override val lat: Option[Double] =
      scala.Option(impl.lat()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.GeoLocation
  ): zio.aws.securityhub.model.GeoLocation.ReadOnly = new Wrapper(impl)
}
