package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FirewallPolicyStatefulRuleGroupReferencesDetails(
    resourceArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails = {
    import FirewallPolicyStatefulRuleGroupReferencesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
      .builder()
      .optionallyWith(
        resourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
      .wrap(buildAwsValue())
}
object FirewallPolicyStatefulRuleGroupReferencesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails =
      zio.aws.securityhub.model
        .FirewallPolicyStatefulRuleGroupReferencesDetails(
          resourceArn.map(value => value)
        )
    def resourceArn: Option[NonEmptyString]
    def getResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly {
    override val resourceArn: Option[NonEmptyString] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
  ): zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly =
    new Wrapper(impl)
}
