package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FirewallPolicyDetails(
    statefulRuleGroupReferences: Option[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
    ]] = None,
    statelessCustomActions: Option[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
    ]] = None,
    statelessDefaultActions: Option[Iterable[NonEmptyString]] = None,
    statelessFragmentDefaultActions: Option[Iterable[NonEmptyString]] = None,
    statelessRuleGroupReferences: Option[Iterable[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails = {
    import FirewallPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
      .builder()
      .optionallyWith(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroupReferences)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statelessDefaultActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessDefaultActions)
      .optionallyWith(
        statelessFragmentDefaultActions.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessFragmentDefaultActions)
      .optionallyWith(
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroupReferences)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.FirewallPolicyDetails.wrap(buildAwsValue())
}
object FirewallPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FirewallPolicyDetails =
      zio.aws.securityhub.model.FirewallPolicyDetails(
        statefulRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessCustomActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions.map(value => value),
        statelessFragmentDefaultActions.map(value => value),
        statelessRuleGroupReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statefulRuleGroupReferences: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]]
    def statelessCustomActions: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]]
    def statelessDefaultActions: Option[List[NonEmptyString]]
    def statelessFragmentDefaultActions: Option[List[NonEmptyString]]
    def statelessRuleGroupReferences: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]]
    def getStatefulRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statefulRuleGroupReferences",
      statefulRuleGroupReferences
    )
    def getStatelessCustomActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessCustomActions",
      statelessCustomActions
    )
    def getStatelessDefaultActions: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "statelessDefaultActions",
        statelessDefaultActions
      )
    def getStatelessFragmentDefaultActions
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "statelessFragmentDefaultActions",
      statelessFragmentDefaultActions
    )
    def getStatelessRuleGroupReferences: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statelessRuleGroupReferences",
      statelessRuleGroupReferences
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ) extends zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly {
    override val statefulRuleGroupReferences: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails.ReadOnly
    ]] = scala
      .Option(impl.statefulRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatefulRuleGroupReferencesDetails
            .wrap(item)
        }.toList
      )
    override val statelessCustomActions: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails.ReadOnly
    ]] = scala
      .Option(impl.statelessCustomActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatelessCustomActionsDetails
            .wrap(item)
        }.toList
      )
    override val statelessDefaultActions: Option[List[NonEmptyString]] = scala
      .Option(impl.statelessDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val statelessFragmentDefaultActions: Option[List[NonEmptyString]] =
      scala
        .Option(impl.statelessFragmentDefaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val statelessRuleGroupReferences: Option[List[
      zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails.ReadOnly
    ]] = scala
      .Option(impl.statelessRuleGroupReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.FirewallPolicyStatelessRuleGroupReferencesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FirewallPolicyDetails
  ): zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly = new Wrapper(
    impl
  )
}
