package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FindingProviderSeverity(
    label: Option[zio.aws.securityhub.model.SeverityLabel] = None,
    original: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity = {
    import FindingProviderSeverity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity
      .builder()
      .optionallyWith(label.map(value => value.unwrap))(_.label)
      .optionallyWith(
        original.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.original)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly =
    zio.aws.securityhub.model.FindingProviderSeverity.wrap(buildAwsValue())
}
object FindingProviderSeverity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingProviderSeverity =
      zio.aws.securityhub.model.FindingProviderSeverity(
        label.map(value => value),
        original.map(value => value)
      )
    def label: Option[zio.aws.securityhub.model.SeverityLabel]
    def original: Option[NonEmptyString]
    def getLabel: ZIO[Any, AwsError, zio.aws.securityhub.model.SeverityLabel] =
      AwsError.unwrapOptionField("label", label)
    def getOriginal: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("original", original)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity
  ) extends zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly {
    override val label: Option[zio.aws.securityhub.model.SeverityLabel] = scala
      .Option(impl.label())
      .map(value => zio.aws.securityhub.model.SeverityLabel.wrap(value))
    override val original: Option[NonEmptyString] = scala
      .Option(impl.original())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingProviderSeverity
  ): zio.aws.securityhub.model.FindingProviderSeverity.ReadOnly = new Wrapper(
    impl
  )
}
